

- globals
  Global
    sf = fallback(IntensityFromMidi(1,0), 0) // deactivate filters at start
    pulse =                          filter(IntensityFromMidiCC(1,15), sf * 0.01)
    melpulse =                       filter(IntensityFromMidiCC(1,16), sf * 0.1)
    a1slow =                         filter(IntensityFromMidiCC(1,17), sf * 0.1)
    a2slow =                         filter(IntensityFromMidiCC(1,18), sf * 0.1)
    a1mix =    mix(a1slow, pulse,    filter(IntensityFromMidiCC(1,19), sf * 0.1))
    a2mix =    mix(a2slow, melpulse, filter(IntensityFromMidiCC(1,20), sf * 0.1))
    ccFaceMul =                             IntensityFromMidiCC(1,21)

    buildup =                        filter(IntensityFromMidiCC(1,22), sf * 0.3)

    rippleMain =  fract(t_drummer2 * (142/60)/2)
    rippleEnd = t_drummer2 / 10
    ripple = mix(rippleMain, rippleEnd, ending)
 
    bgEnable = not bool(IntensityFromMidi(1,1))
    ending =            IntensityFromMidi(1,2)
    credits =           IntensityFromMidi(1,3)

    ccCamX =                         filter(IntensityFromMidiCC(1,91), 0)    
    ccCamY =                         filter(IntensityFromMidiCC(1,92), 0)    
    ccDolly =                        filter(IntensityFromMidiCC(1,93), 0)    
    ccBlack =                               IntensityFromMidiCC(1,94)      

    t_lute =     FramePosFromMidi(3, 26) / 60
    t_lute2 =    FramePosFromMidi(3, 28) / 60
    t_marten =   FramePosFromMidi(3, 30) / 60
    t_harp =     FramePosFromMidi(3, 32) / 60
    t_drummer2 = FramePosFromMidi(3, 34) / 60
    t_schendel = FramePosFromMidi(3, 36) / 60
    t_violin =   FramePosFromMidi(3, 38) / 60
    t_credits =  FramePosFromMidi(3, 40) / 60

    a_lute =     FrameIntensityFromMidi(3, 26)
    a_lute2 =    FrameIntensityFromMidi(3, 28)
    a_marten =   FrameIntensityFromMidi(3, 30)
    a_harp =     FrameIntensityFromMidi(3, 32)
    a_drummer2 = FrameIntensityFromMidi(3, 34)
    a_schendel = FrameIntensityFromMidi(3, 36)
    a_violin =   FrameIntensityFromMidi(3, 38)
    a_credits =  FrameIntensityFromMidi(3, 40)

    drummerZoom = smoothstep(0,20,a_drummer2*t_drummer2)

- BLACK
  ShaderRect ; Shader = 'black-fade-on-top' ; Intensity = 1 - ccBlack

- CREDITS
  ShaderRect ; Intensity = credits ; MaterialRef = Material(shader = 'Unlit', texture = LoadTexture('credits.png'))

- CAM
  CameraControl
    X = 3  * (ccCamX-0.5)
    Y = 3  * (ccCamY-0.5) + drummerZoom*1.2
    Dolly = ccDolly * 4
    FOV = 20
    Zoom = pow(2, 0 -       drummerZoom*1.5)
    FXAmount = 0
    FXGlitch = 0
    FXBloom = 0



- lute
  Puppet ; PuppetFolder = 'lute'
    Matrix = MatrixFromTRS(0, 0.02, 0,    0, 0, 0,    0.15)
    DrawBg = bgEnable
    Frame = t_lute * 30
    Intensity = a_lute
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- lute2
  Puppet ; PuppetFolder = 'lute2'
    Matrix = MatrixFromTRS(-0.36, -1, 0,    0, 0, 0,    0.0585)
    DrawBg = bgEnable
    Frame = t_lute2 * 25
    Intensity = a_lute2
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- marten
  Global
    martenMain = (0, 2.89 - smoothstep(4,13,t_marten) * 5.3, 0,    0, 0, 0,    0.1)
    martenFoot = (-0.08026044, 3.566021, -4.381258,    0,0,0,    0.1)
  Puppet ; PuppetFolder = 'marten'
    Matrix = mix(martenFoot, martenMain, smoothstep(2.3,4,t_marten) ) -> MatrixFromTRS
    DrawBg = bgEnable
    Frame = (t_marten - 10) * 30
    Intensity = a_marten
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- harp
  Global
    harpIntro =                 (5.814458, -4.893266, 0.008921623,    0,0,0,    0.3203717)
    harpIntro2 = mix(harpIntro, (0.85, -2.5, 0,  0,0,0,  0.3303717), smoothstep(0, 13, t_harp))
    harpMat =    mix(harpIntro2,(0.58, -0.71, 0,  0,0,0,  0.14), smoothstep(13 , 19, t_harp))
  Puppet ; PuppetFolder = 'harp'
    Matrix = harpMat -> MatrixFromTRS
    DrawBg = bgEnable
    Frame = (t_harp-3) * 20
    Intensity =  max(max(a_violin,a_lute2), max(a_harp, a_schendel) )
    DrawPuppet = not bool(a_violin + a_schendel + a_lute2)
    Parallax = 0.033 - a_schendel * t_schendel / 80 - a_violin * (t_violin / 80 + 0.05)  - a_lute2 * (t_lute2 / 180 + 0.08) 
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- drummer2
  Puppet ; PuppetFolder = 'drummer2'
    Matrix = MatrixFromTRS(0, -0.33, 0,    0, 0, 0,    0.09)
    DrawBg = bgEnable
    DrawPuppet = not bool(a_violin + a_schendel + a_lute2 + a_harp + a_marten + ending)
    Frame = t_drummer2 * 30
    Intensity = a_drummer2
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- schendel
  Puppet ; PuppetFolder = 'schendel'
    Matrix = MatrixFromTRS(0, -0.49, 0,    0, 0, 0,    0.0825)
    DrawBg = bgEnable
    Frame = t_schendel * 30
    Intensity = a_schendel
    Parallax = 0.05-t_schendel / 40 
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- violin
  Puppet ; PuppetFolder = 'violin'
    Matrix = MatrixFromTRS(0.6, -0.15, 0,    0, 0, 0,    0.11)
    DrawBg = bgEnable
    Frame = t_violin * 30
    Intensity = a_violin
    Axis1 = a1mix
    Axis2 = a2mix
    FaceAnimMul = ccFaceMul

- BG 
  Global
    texMf = LoadTexture('magicflute.jpg')
    texMfStars = LoadTexture('magicflute-stars.png')
    texMfClouds = LoadTexture('magicflute-clouds.png')
    texNoise = LoadTexture('noise_512_99_111.png') 
    bgMat = Material(shader = 'Shaders/MagicFlute', texture = texMf, _StarsTex = texMfStars, _CloudsTex = texMfClouds, _NoiseTex = texNoise, _Buildup = buildup, _RippleTime = ripple, _LocalTime = drummerZoom)
  ShaderRect
    Matrix = MatrixFromTRS(0, 1, 0.6,    0, 0, 0,    1)
    SizeInScene = 8.1
    Intensity = a_drummer2
    MaterialRef = bgMat
    Aspect = 3451 / 2222
    UseMainCamera = false

- music
  AudioTimeline
    Resource = "teadrinker-the-musicians-soundtrack.mp3"
    SyncFile = "sync.mid"